#!/bin/bash
MODEL_PATH=$1
DATASET="pope"
question_file="<OUTPUT_FOLDER>/llava/eval/pope/llava_pope_test.jsonl"
pred_file=${MODEL_PATH}/${DATASET}/answers/merge.jsonl
image_folder="<DATA_FOLDER>/coco/val2014"

pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

if [ -z "${pred_data}" ]; then
    MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
    if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
        echo "qwen-vl in $MODEL_PATH"
        echo "pred file does not exist for ${DATASET}"
        exit 1 
    fi

    python -m llava.eval.model_vqa_loader \
        --model-path ${MODEL_PATH} \
        --question-file ${question_file} \
        --image-folder ${image_folder} \
        --answers-file ${pred_file} \
        --temperature 0 \
        --conv-mode vicuna_v1

else
    echo "pred file exists for ${DATASET}"
    pred_file=${pred_data}
fi

python llava/eval/eval_pope.py \
    --annotation-dir <DATA_FOLDER>/POPE \
    --question-file ${question_file} \
    --result-file ${pred_file} --overwrite 

